﻿/*=====================================================================
  File:      MakeLex.cs

  Summary:   create a binary lexicon file.

---------------------------------------------------------------------

  Copyright (C) Mark Watson.  All rights reserved.

THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY
KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
PARTICULAR PURPOSE.
=====================================================================*/


using System;
using System.Text;
using System.IO;
using System.Runtime.Serialization;
using System.Runtime.Serialization.Formatters.Binary;
using System.Collections;

namespace WordNetTools
{

    public class App
    {

        public static void Main(String[] args)
        {
            try
            {
                Hashtable hash = new Hashtable();
                //int count = 0;
                FileInfo lexFile = new FileInfo("LEXICON");
                StreamReader reader = lexFile.OpenText();
                string line;
                do
                {
                    line = reader.ReadLine();
                    if (line == null) break;
                    int index = line.IndexOf(" ");
                    //Console.WriteLine("line: " + line + " index: " + index);
                    string word = line.Substring(0, index).Trim();
                    string tags = line.Substring(index).Trim();
                    //Console.WriteLine("word: " + word + ", tags: " + tags);
                    //count++;
                    if (hash[word] == null) hash.Add(word, tags);
                } while (line != null);
                reader.Close();
                Stream file = File.Open("lex.dat", FileMode.Create);
                IFormatter formatter = (IFormatter)new BinaryFormatter();
                // Serialize the object hashto stream
                formatter.Serialize(file, hash);
                file.Close();
            }
            catch (Exception e2)
            {
                Console.WriteLine("Error: " + e2);
            }
        }

    }
}